% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-config.R
\name{drake_config}
\alias{drake_config}
\title{Create the internal runtime parameter list
used internally in \code{\link[=make]{make()}}.}
\usage{
drake_config(plan, targets = NULL, envir = parent.frame(),
  verbose = 1L, hook = NULL, cache = drake::get_cache(verbose =
  verbose, console_log_file = console_log_file), fetch_cache = NULL,
  parallelism = "loop", jobs = 1L, jobs_preprocess = 1L,
  packages = rev(.packages()), lib_loc = NULL,
  prework = character(0), prepend = NULL, command = NULL,
  args = NULL, recipe_command = NULL, timeout = NULL, cpu = Inf,
  elapsed = Inf, retries = 0, force = FALSE, log_progress = FALSE,
  graph = NULL, trigger = drake::trigger(), skip_targets = FALSE,
  skip_imports = FALSE, skip_safety_checks = FALSE,
  lazy_load = "eager", session_info = TRUE, cache_log_file = NULL,
  seed = NULL, caching = c("master", "worker"), keep_going = FALSE,
  session = NULL, pruning_strategy = NULL, makefile_path = NULL,
  console_log_file = NULL, ensure_workers = TRUE,
  garbage_collection = FALSE, template = list(), sleep = function(i)
  0.01, hasty_build = NULL, memory_strategy = c("speed", "memory",
  "lookahead"), layout = NULL, lock_envir = TRUE)
}
\arguments{
\item{plan}{Workflow plan data frame.
A workflow plan data frame is a data frame
with a \code{target} column and a \code{command} column.
(See the details in the \code{\link[=drake_plan]{drake_plan()}} help file
for descriptions of the optional columns.)
Targets are the objects that drake generates,
and commands are the pieces of R code that produce them.
You can create and track custom files along the way
(see \code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, and \code{\link[=knitr_in]{knitr_in()}}).
Use the function \code{\link[=drake_plan]{drake_plan()}} to generate workflow plan
data frames.}

\item{targets}{Character vector, names of targets to build.
Dependencies are built too. Together, the \code{plan} and
\code{targets} comprise the workflow network
(i.e. the \code{graph} argument).
Changing either will change the network.}

\item{envir}{Environment to use. Defaults to the current
workspace, so you should not need to worry about this
most of the time. A deep copy of \code{envir} is made,
so you don't need to worry about your workspace being modified
by \code{make}. The deep copy inherits from the global environment.
Wherever necessary, objects and functions are imported
from \code{envir} and the global environment and
then reproducibly tracked as dependencies.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{hook}{Deprecated.}

\item{cache}{drake cache as created by \code{\link[=new_cache]{new_cache()}}.
See also \code{\link[=get_cache]{get_cache()}}.}

\item{fetch_cache}{Deprecated.}

\item{parallelism}{Character scalar, type of parallelism to use.
For detailed explanations, see the
\href{https://ropenscilabs.github.io/drake-manual/hpc.html}{high-performance computing chapter}
of the user manual.

You could also supply your own scheduler function
if you want to experiment or aggressively optimize.
The function should take a single \code{config} argument
(produced by \code{\link[=drake_config]{drake_config()}}). Existing examples
from \code{drake}'s internals are the \code{backend_*()} functions:
\itemize{
\item \code{backend_loop()}
\item \code{backend_clustermq()}
\item \code{backend_future()}
\item \code{backend_hasty()} (unofficial)
However, this functionality is really a back door
and should not be used for production purposes unless you really
know what you are doing and you are willing to suffer setbacks
whenever \code{drake}'s unexported core functions are updated.
}}

\item{jobs}{Maximum number of parallel workers for processing the targets.
You can experiment with \code{\link[=predict_runtime]{predict_runtime()}}
to help decide on an appropriate number of jobs.
For details, visit
\url{https://ropenscilabs.github.io/drake-manual/time.html}.}

\item{jobs_preprocess}{Number of parallel jobs for processing the imports
and doing other preprocessing tasks.}

\item{packages}{Character vector packages to load, in the order
they should be loaded. Defaults to \code{rev(.packages())}, so you
should not usually need to set this manually. Just call
\code{\link[=library]{library()}} to load your packages before \code{make()}.
However, sometimes packages need to be strictly forced to load
in a certain order, especially if \code{parallelism} is
\code{"Makefile"}. To do this, do not use \code{\link[=library]{library()}}
or \code{\link[=require]{require()}} or \code{\link[=loadNamespace]{loadNamespace()}} or
\code{\link[=attachNamespace]{attachNamespace()}} to load any libraries beforehand.
Just list your packages in the \code{packages} argument in the order
you want them to be loaded.}

\item{lib_loc}{Character vector, optional.
Same as in \code{library()} or \code{require()}.
Applies to the \code{packages} argument (see above).}

\item{prework}{Expression (language object), list of expressions,
or character vector.
Code to run right before targets build.
Called only once if \code{parallelism} is \code{"loop"}
and once per target otherwise.
This code can be used to set global options, etc.}

\item{prepend}{Deprecated.}

\item{command}{Deprecated.}

\item{args}{Deprecated.}

\item{recipe_command}{Deprecated.}

\item{timeout}{\code{deprecated}. Use \code{elapsed} and \code{cpu} instead.}

\item{cpu}{Same as the \code{cpu} argument of \code{setTimeLimit()}.
Seconds of cpu time before a target times out.
Assign target-level cpu timeout times with an optional \code{cpu}
column in \code{plan}.}

\item{elapsed}{Same as the \code{elapsed} argument of \code{setTimeLimit()}.
Seconds of elapsed time before a target times out.
Assign target-level elapsed timeout times with an optional \code{elapsed}
column in \code{plan}.}

\item{retries}{Number of retries to execute if the target fails.
Assign target-level retries with an optional \code{retries}
column in \code{plan}.}

\item{force}{Logical. If \code{FALSE} (default) then \code{drake}
imposes checks if the cache was created with an old
and incompatible version of drake.
If there is an incompatibility, \code{make()} stops to
give you an opportunity to
downgrade \code{drake} to a compatible version
rather than rerun all your targets from scratch.}

\item{log_progress}{Logical, whether to log the progress
of individual targets as they are being built. Progress logging
creates a lot of little files in the cache, and it may make builds
a tiny bit slower. So you may see gains in storage efficiency
and speed with
\code{make(..., log_progress = FALSE)}.}

\item{graph}{An \code{igraph} object from the previous \code{make()}.
Supplying a pre-built graph could save time.}

\item{trigger}{Name of the trigger to apply to all targets.
Ignored if \code{plan} has a \code{trigger} column.
See \code{\link[=trigger]{trigger()}} for details.}

\item{skip_targets}{Logical, whether to skip building the targets
in \code{plan} and just import objects and files.}

\item{skip_imports}{Logical, whether to totally neglect to
process the imports and jump straight to the targets. This can be useful
if your imports are massive and you just want to test your project,
but it is bad practice for reproducible data analysis.
This argument is overridden if you supply your own \code{graph} argument.}

\item{skip_safety_checks}{Logical, whether to skip the safety checks
on your workflow. Use at your own peril.}

\item{lazy_load}{Either a character vector or a logical. Choices:
\itemize{
\item \code{"eager"}: no lazy loading. The target is loaded right away
with \code{\link[=assign]{assign()}}.
\item \code{"promise"}: lazy loading with \code{\link[=delayedAssign]{delayedAssign()}}
\item \code{"bind"}: lazy loading with active bindings:
\code{bindr::populate_env()}.
\item \code{TRUE}: same as \code{"promise"}.
\item \code{FALSE}: same as \code{"eager"}.
}

\code{lazy_load} should not be \code{"promise"}
for \code{"parLapply"} parallelism combined with \code{jobs} greater than 1.
For local multi-session parallelism and lazy loading, try
\code{library(future); future::plan(multisession)} and then
\code{make(..., parallelism = "future_lapply", lazy_load = "bind")}.

If \code{lazy_load} is \code{"eager"},
drake prunes the execution environment before each target/stage,
removing all superfluous targets
and then loading any dependencies it will need for building.
In other words, drake prepares the environment in advance
and tries to be memory efficient.
If \code{lazy_load} is \code{"bind"} or \code{"promise"}, drake assigns
promises to load any dependencies at the last minute.
Lazy loading may be more memory efficient in some use cases, but
it may duplicate the loading of dependencies, costing time.}

\item{session_info}{Logical, whether to save the \code{sessionInfo()}
to the cache. This behavior is recommended for serious \code{\link[=make]{make()}}s
for the sake of reproducibility. This argument only exists to
speed up tests. Apparently, \code{sessionInfo()} is a bottleneck
for small \code{\link[=make]{make()}}s.}

\item{cache_log_file}{Name of the cache log file to write.
If \code{TRUE}, the default file name is used (\code{drake_cache.log}).
If \code{NULL}, no file is written.
If activated, this option writes a flat text file
to represent the state of the cache
(fingerprints of all the targets and imports).
If you put the log file under version control, your commit history
will give you an easy representation of how your results change
over time as the rest of your project changes. Hopefully,
this is a step in the right direction for data reproducibility.}

\item{seed}{Integer, the root pseudo-random number generator
seed to use for your project.
In \code{\link[=make]{make()}}, \code{drake} generates a unique
local seed for each target using the global seed
and the target name. That way, different pseudo-random numbers
are generated for different targets, and this pseudo-randomness
is reproducible.

To ensure reproducibility across different R sessions,
\code{set.seed()} and \code{.Random.seed} are ignored and have no affect on
\code{drake} workflows. Conversely, \code{make()} does not usually
change \code{.Random.seed},
even when pseudo-random numbers are generated.
The exceptions to this last point are
\code{make(parallelism = "clustermq")} and
\code{make(parallelism = "clustermq_staged")},
because the \code{clustermq} package needs to generate random numbers
to set up ports and sockets for ZeroMQ.

On the first call to \code{make()} or \code{drake_config()}, \code{drake}
uses the random number generator seed from the \code{seed} argument.
Here, if the \code{seed} is \code{NULL} (default), \code{drake} uses a \code{seed} of \code{0}.
On subsequent \code{make()}s for existing projects, the project's
cached seed will be used in order to ensure reproducibility.
Thus, the \code{seed} argument must either be \code{NULL} or the same
seed from the project's cache (usually the \code{.drake/} folder).
To reset the random number generator seed for a project,
use \code{clean(destroy = TRUE)}.}

\item{caching}{Character string, only applies to
\code{"clustermq"}, \code{"clustermq_staged"}, and \code{"future"} parallel backends.
The \code{caching} argument can be either \code{"master"} or \code{"worker"}.
\itemize{
\item \code{"master"}: Targets are built by remote workers and sent back to
the master process. Then, the master process saves them to the
cache (\code{config$cache}, usually a file system \code{storr}).
Appropriate if remote workers do not have access to the file system
of the calling R session. Targets are cached one at a time,
which may be slow in some situations.
\item \code{"worker"}: Remote workers not only build the targets, but also
save them to the cache. Here, caching happens in parallel.
However, remote workers need to have access to the file system
of the calling R session. Transferring target data across
a network can be slow.
}}

\item{keep_going}{Logical, whether to still keep running \code{\link[=make]{make()}}
if targets fail.}

\item{session}{Deprecated. Has no effect now.}

\item{pruning_strategy}{Deprecated. See \code{memory_strategy}.}

\item{makefile_path}{Path to the \code{Makefile} for
\code{make(parallelism = "Makefile")}. If you set this argument to a
non-default value, you are responsible for supplying this same
path to the \code{args} argument so \code{make} knows where to find it.
Example: \code{make(parallelism = "Makefile", makefile_path = ".drake/.makefile", command = "make", args = "--file=.drake/.makefile")}}

\item{console_log_file}{Character scalar,
connection object (such as \code{stdout()}) or \code{NULL}.
If \code{NULL}, console output will be printed
to the R console using \code{message()}.
If a character scalar, \code{console_log_file}
should be the name of a flat file, and
console output will be appended to that file.
If a connection object (e.g. \code{stdout()})
warnings and messages will be sent to the connection.
For example, if \code{console_log_file} is \code{stdout()},
warnings and messages are printed to the console in real time
(in addition to the usual in-bulk printing
after each target finishes).}

\item{ensure_workers}{Logical, whether the master process
should wait for the workers to post before assigning them
targets. Should usually be \code{TRUE}. Set to \code{FALSE}
for \code{make(parallelism = "future_lapply", jobs = n)}
(\code{n > 1}) when combined with \code{future::plan(future::sequential)}.
This argument only applies to parallel computing with persistent workers
(\code{make(parallelism = x)}, where \code{x} could be \code{"mclapply"},
\code{"parLapply"}, or \code{"future_lapply"}).}

\item{garbage_collection}{Logical, whether to call \code{gc()} each time
a target is built during \code{\link[=make]{make()}}.}

\item{template}{A named list of values to fill in the \code{{{ ... }}}
placeholders in template files (e.g. from \code{\link[=drake_hpc_template_file]{drake_hpc_template_file()}}).
Same as the \code{template} argument of \code{clustermq::Q()} and
\code{clustermq::workers}.
Enabled for \code{clustermq} only (\code{make(parallelism = "clustermq_staged")}),
not \code{future} or \code{batchtools} so far.
For more information, see the \code{clustermq} package:
\url{https://github.com/mschubert/clustermq}.
Some template placeholders such as \code{{{ job_name }}} and \code{{{ n_jobs }}}
cannot be set this way.}

\item{sleep}{In its parallel processing, \code{drake} uses
a central master process to check what the parallel
workers are doing, and for the affected high-performance
computing workflows, wait for data to arrive over a network.
In between loop iterations, the master process sleeps to avoid throttling.
The \code{sleep} argument to \code{make()} and \code{drake_config()}
allows you to customize how much time the master process spends
sleeping.

The \code{sleep} argument is a function that takes an argument
\code{i} and returns a numeric scalar, the number of seconds to
supply to \code{Sys.sleep()} after iteration \code{i} of checking.
(Here, \code{i} starts at 1.)
If the checking loop does something other than sleeping
on iteration \code{i}, then \code{i} is reset back to 1.

To sleep for the same amount of time between checks,
you might supply something like \code{function(i) 0.01}.
But to avoid consuming too many resources during heavier
and longer workflows, you might use an exponential
back-off: say,
\code{function(i) { 0.1 + 120 * pexp(i - 1, rate = 0.01) }}.}

\item{hasty_build}{A user-defined function.
In "hasty mode" (\code{make(parallelism = "hasty")})
this is the function that evaluates a target's command
and returns the resulting value. The \code{hasty_build} argument
has no effect if \code{parallelism} is any value other than "hasty".

The function you pass to \code{hasty_build} must have arguments \code{target}
and \code{config}. Here, \code{target} is a character scalar naming the
target being built, and \code{config} is a configuration list of
runtime parameters generated by \code{\link[=drake_config]{drake_config()}}.}

\item{memory_strategy}{Character scalar, name of the
strategy \code{drake} uses to manage targets in memory. For more direct
control over which targets \code{drake} keeps in memory, see the
help file examples of \code{\link[=drake_envir]{drake_envir()}}. The \code{memory_strategy} argument
to \code{make()} and \code{drake_config()} is an attempt at an automatic
catch-all solution. These are the choices.
\itemize{
\item \code{"speed"}: Once a target is loaded in memory, just keep it there.
This choice maximizes speed and hogs memory.
\item \code{"memory"}: Just before building each new target,
unload everything from memory except the target's direct dependencies.
This option conserves memory, but it sacrifices speed because
each new target needs to reload
any previously unloaded targets from storage.
\item \code{"lookahead"}: Just before building each new target,
search the dependency graph to find targets that will not be
needed for the rest of the current \code{make()} session.
In this mode, targets are only in memory if they need to be loaded,
and we avoid superfluous reads from the cache.
However, searching the graph takes time,
and it could even double the computational overhead for large projects.
}

Each strategy has a weakness.
\code{"speed"} is memory-hungry, \code{"memory"} wastes time reloading
targets from storage, and \code{"lookahead"} wastes time
traversing the entire dependency graph on every \code{\link[=make]{make()}}. For a better
compromise and more control, see the examples in the help file
of \code{\link[=drake_envir]{drake_envir()}}.}

\item{layout}{\code{config$layout}, where \code{config} is the return value
from a prior call to \code{drake_config()}. If your plan or environment
have changed since the last \code{make()}, do not supply a \code{layout} argument.
Otherwise, supplying one could save time.}

\item{lock_envir}{Logical, whether to lock \code{config$envir} during \code{make()}.
If \code{TRUE}, \code{make()} quits in error whenever a command in your
\code{drake} plan (or \code{prework}) tries to add, remove, or modify
non-hidden variables in your environment/workspace/R session.
This is extremely important for ensuring the purity of your functions
and the reproducibility/credibility/trust you can place in your project.
\code{lock_envir} will be set to a default of \code{TRUE} in \code{drake} version
7.0.0 and higher.}
}
\value{
The master internal configuration list of a project.
}
\description{
\code{\link[=drake_config]{drake_config()}} collects and sanitizes the multitude of
parameters and settings that \code{\link[=make]{make()}} needs to do its job:
the plan, packages,
the environment of functions and initial data objects,
parallel computing instructions,
verbosity level, etc. Other functions such as \code{\link[=outdated]{outdated()}},
\code{\link[=vis_drake_graph]{vis_drake_graph()}}, and \code{\link[=predict_runtime]{predict_runtime()}} require output from
\code{\link[=drake_config]{drake_config()}} for the \code{config} argument.
If you supply a \code{\link[=drake_config]{drake_config()}} object to the \code{config}
argument of \code{\link[=make]{make()}}, then \code{drake} will ignore all the other arguments
because it already has everything it needs in \code{config}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Construct the master internal configuration list.
config <- drake_config(my_plan)
if (requireNamespace("visNetwork")) {
  vis_drake_graph(config) # See the dependency graph.
  if (requireNamespace("networkD3")) {
    sankey_drake_graph(config) # See the dependency graph.
  }
}
# These functions are faster than otherwise
# because they use the configuration list.
outdated(config) # Which targets are out of date?
missed(config) # Which imports are missing?
})
}
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}}
}
