% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic2.R
\name{logistic2_fn}
\alias{logistic2_fn}
\title{2-parameter logistic function}
\usage{
logistic2_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the logistic function is to be evaluated.}

\item{theta}{numeric vector with the parameters in the form \code{c(eta, phi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
logistic function.
}
\description{
Evaluate at a particular set of parameters the 2-parameter logistic function.
}
\details{
The 2-parameter logistic function \verb{f(x; theta)} is defined here as

\code{1 / (1 + exp(-eta * (x - phi)))}

where \code{theta = c(eta, phi)}, \code{eta} is the steepness of the curve or growth
rate (also known as the Hill coefficient), and \code{phi} is the value of \code{x} at
which the curve is equal to its mid-point, i.e. 1 / 2.
}
