% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{words_probabilities}
\alias{words_probabilities}
\title{Probability of appearance of several words at several positions of a DMM}
\usage{
words_probabilities(words, pos, x, output_file = NULL, plot = FALSE)
}
\arguments{
\item{words}{A vector of characters containing words}

\item{pos}{A vector of integer positions}

\item{x}{An object of class \code{dmm}}

\item{output_file}{(Optional) A file containing the matrix of probabilities (e.g,"C:/.../PROB.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display figure plots of words' probabilities by position)}
}
\value{
A dataframe of word probabilities along the positions of the sequence
}
\description{
Probability of appearance of several words at several positions of a DMM
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq",
fit.method="sum")
words <- c("atcgattc", "taggct", "ggatcgg")
pos <- c(100,300)
words_probabilities(words=words,pos=pos,dmm,plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{word_probability}, \link[drimmR]{word_probabilities}
}
\author{
Victor Mataigne, Alexandre Seiller
}
