% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm.R
\name{PsProg_tte}
\alias{PsProg_tte}
\title{Probability of a successful program for multiarm programs with time-to-event outcomes}
\usage{
PsProg_tte(HRgo, n2, alpha, beta, ec, hr1, hr2, step1, step2, strategy, case)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be divisible by three}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{ec}{control arm event rate for phase II and III}

\item{hr1}{assumed true treatment effect on HR scale for treatment 1}

\item{hr2}{assumed true treatment effect on HR scale for treatment 2}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{strategy}{choose Strategy: 1 ("only best promising"), 2 ("all promising") or 3 (both)}

\item{case}{different cases: 1 ("nogo"), 21 (treatment 1 is promising, treatment 2 is not), 22 (treatment 2 is promising, treatment 1 is not), 31 (both treatments are promising, treatment 1 is better), 32 (both treatments are promising, treatment 2 is better)}
}
\value{
The function PsProg_tte() returns the probability of a successful program
}
\description{
Given we get the "go"-decision in phase II, this functions now calculates the probability that the results of the confirmatory trial (phase III) are significant, i.e. we have a statistically relevant positive effect of the treatment.
}
\examples{
res <- PsProg_tte(HRgo = 0.8 ,n2 = 50 ,alpha = 0.05, beta = 0.1,
                            ec = 0.6, hr1 = 0.7, hr2 = 0.8, step1 = 1, step2 = 0.95,
                            strategy = 2, case = 21)
}
\keyword{internal}
