% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{drug_prep}
\alias{drug_prep}
\title{Run drug preparation algorithm}
\usage{
drug_prep(data, plausible_values, decisions = rep("a", 10))
}
\arguments{
\item{data}{data frame containing prescription data}

\item{plausible_values}{data frame containing variables \code{prodcode},
\code{min_qty}, \code{max_qty}, \code{min_ndd}, \code{max_ndd} describing
plausible ranges for values for each drug}

\item{decisions}{character vector of length 10}
}
\value{
A data frame including estimated \code{stop_date} for each prescription
}
\description{
Run drug preparation algorithm
}
\examples{
plausible_values <- data.frame(
  prodcode = c('a', 'b', 'c'),
  min_qty = 0,
  max_qty = c(50, 100, 200),
  min_ndd = 0,
  max_ndd = c(10, 20, 30)
)
drug_prep(example_therapy,
          plausible_values,
          decisions = c('a', 'a', 'a', 'a', 'a',
                        'c', 'a', 'a', 'a', 'a'))

}
\seealso{
Other decision functions: 
\code{\link{decision_10}()},
\code{\link{decision_1}()},
\code{\link{decision_2}()},
\code{\link{decision_3}()},
\code{\link{decision_4}()},
\code{\link{decision_5}()},
\code{\link{decision_6}()},
\code{\link{decision_7}()},
\code{\link{decision_8}()},
\code{\link{decision_9}()}
}
\concept{decision functions}
