% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\docType{data}
\name{cclass}
\alias{cclass}
\title{cclass provides character classes (as a named vector).}
\format{
An object of class \code{character} of length 6.
}
\usage{
cclass
}
\description{
\code{cclass} provides different character classes  
(as a named character vector).
}
\details{
\code{cclass} allows illustrating matching 
character classes via regular expressions. 

See \code{?base::regex} for details on regular expressions 
and \code{?"'"} for a list of character constants/quotes in R.
}
\examples{
cclass["hex"]  # select by name
writeLines(cclass["pun"])
grep("[[:alpha:]]", cclass, value = TRUE)

}
\seealso{
\code{\link{metachar}} for a vector of metacharacters.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
\keyword{datasets}
