% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{output}
\alias{output}
\title{Creating Output for dsa}
\usage{
output(
  daily.object,
  path = getwd(),
  short = FALSE,
  SI = TRUE,
  SI365.seed = 3,
  spec = TRUE,
  outlier = TRUE,
  Factor = "auto",
  everyDay = TRUE,
  seasonals = FALSE,
  spectrum_linesize = 0.5,
  progressBar = TRUE
)
}
\arguments{
\item{daily.object}{output of dsa() function}

\item{path}{Path that HTML file is written to}

\item{short}{Boolean. If true only short version of output is produced}

\item{SI}{Including graphs of SI-ratios}

\item{SI365.seed}{This seed influences which days of the year are shown as SI-ratios}

\item{spec}{Boolean. Inclusion of spectral plots}

\item{outlier}{Boolean. Inclusion of outlier plots}

\item{Factor}{Scaling factor for series with large values}

\item{everyDay}{Boolean. Inclusion of table that summarizes daily results}

\item{seasonals}{Boolean. Plots of seasonal factors as interactive instead of static graph.}

\item{spectrum_linesize}{Width of lines in spectrum.}

\item{progressBar}{Should a progress bar be displayed?}
}
\description{
This function creates HTML output in a specified folder for objects of class daily
}
\details{
This function can be used to create plots and tables necessary for the analysis of seasonally and calendar adjusted daily time series. Uses the output of dsa() as an input.
}
\examples{
res <- dsa(daily_sim(4)$original, cval=7, model=c(3,1,0),fourier_number = 13, reg.create=NULL)
\dontrun{output(res)}
}
\author{
Daniel Ollech
}
