% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reference.R
\name{get_reference}
\alias{get_reference}
\title{Get D-score reference}
\usage{
get_reference(
  population = NULL,
  key = NULL,
  references = dscore::builtin_references,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{population}{String. The name of the reference population to calculate
DAZ.
Use \code{with(builtin_references, table(key, population))} to see which
built-in references are available for \code{key - population} combinations.
If not specified, the function set the default population as
\code{builtin_keys$base_population[key == builtin_keys$key]}.}

\item{key}{String. They key identifies 1) the difficulty estimates
pertaining to a particular Rasch model, and 2) the prior mean and standard
deviation of the prior distribution for calculating the D-score.
The default key \code{NULL} sets \code{key = "gsed2406"}.
View \code{builtin_keys} for an overview of the available keys.}

\item{references}{A \code{data.frame} with the same structure as \code{builtin_references}.
The default is to use \code{builtin_references}.}

\item{verbose}{Logical. Print settings.}

\item{\dots}{Used to test whether the call contained the deprecated argument
\code{references}.}
}
\value{
A \code{data.frame} with the LMS reference values.
}
\description{
The \code{get_reference()} function selects the D-score reference
distribution.
}
\note{
No references for population \code{"gsed"} exist.
The function will silently rewrite \code{population = "gsed"}
into to the \code{population = "gsed"}.

The \code{"dutch"} reference was published in Van Buuren (2014)
The \code{"gcdg"} was calculated from 15 cohorts with direct
observations (Weber, 2019).
The \code{"phase1"} references were calculated from the GSED Phase 1 validation
data (GSED-BGD, GSED-PAK, GSED-TZA) cover age range 2w-3.5 years. The
age range 3.5-5 yrs is linearly extrapolated and are only indicative.
The \code{"preliminary_standards"} references were calculated from the GSED
Phase 1 validation using a subset of children with healthy development.
}
\examples{
# see key-population combinations of builtin_references
table(builtin_references$key, builtin_references$population)

# get the default reference
reftab <- get_reference()
head(reftab, 2)

# get the default reference for the key "gsed2212"
reftab <- get_reference(key = "gsed2212", verbose = TRUE)

# get dutch reference for default key
reftab <- get_reference(population = "dutch", verbose = TRUE)

# loading a non-existing reference yields zero rows
reftab <- get_reference(population = "france", verbose = TRUE)
nrow(reftab)
}
\references{
Van Buuren S (2014). Growth charts of human development.
Stat Methods Med Res, 23(4), 346-368.

Weber AM, Rubio-Codina M, Walker SP, van Buuren S, Eekhout I,
Grantham-McGregor S, Caridad Araujo M, Chang SM, Fernald LCH,
Hamadani JD, Hanlon A, Karam SM, Lozoff B, Ratsifandrihamanana L,
Richter L, Black MM (2019). The D-score: a metric for interpreting
the early development of infants and toddlers across global settings.
BMJ Global Health, BMJ Global Health 4: e001724.
\url{https://gh.bmj.com/content/bmjgh/4/6/e001724.full.pdf}.
}
\seealso{
\code{\link[=builtin_references]{builtin_references()}}
}
