% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_references.R
\docType{data}
\name{builtin_references}
\alias{builtin_references}
\title{Age-conditional reference distribution of D-score}
\format{
A \code{data.frame} with 265 rows and 17 variables:\tabular{ll}{
   Name \tab Label \cr
   \code{pop} \tab Population, either \code{"dutch"} or \code{"gcdg"} \cr
   \code{age} \tab Decimal age in years \cr
   \code{mu} \tab M-curve, median D-score, P50 \cr
   \code{sigma} \tab S-curve, spread expressed as coefficient of variation \cr
   \code{nu} \tab L-curve, the lambda coefficient of the LMS model for skewness \cr
   \code{P3} \tab P3 percentile \cr
   \code{P10} \tab P10 percentile \cr
   \code{P25} \tab P25 percentile \cr
   \code{P50} \tab P50 percentile \cr
   \code{P75} \tab P75 percentile \cr
   \code{P90} \tab P90 percentile \cr
   \code{P97} \tab P97 percentile \cr
   \code{SDM2} \tab -2SD centile \cr
   \code{SDM1} \tab -1SD centile \cr
   \code{SD0} \tab 0SD centile, median \cr
   \code{SDP1} \tab +1SD centile \cr
   \code{SDP2} \tab +2SD centile \cr
}
}
\usage{
builtin_references
}
\description{
A data frame containing the age-dependent distribution of the
D-score for children aged 0-5 years. The distribution is modelled
after the LMS distribution (Cole & Green, 1992), and is equal for
both boys and girls. The LMS values can be used to graph
reference charts and to calculate age-conditonal Z-scores, also
known as DAZ.
}
\details{
The \code{"dutch"} references were calculated from the SMOCC data, and cover
age range 0-2.5 years (van Buuren, 2014).
The \code{"gcdg"} references were calculated from the 15 cohorts of the
GCDG-study, and cover age range 0-5 years (Weber, 2019).
}
\examples{
head(builtin_references)
}
\references{
Cole TJ, Green PJ (1992). Smoothing reference centile curves: The LMS
method and penalized likelihood. Statistics in Medicine, 11(10),
1305-1319.

Van Buuren S (2014). Growth charts of human development.
Stat Methods Med Res, 23(4), 346-368.
\href{https://stefvanbuuren.name/publications/2014\%20Growth\%20charts\%20for\%20development\%20-\%20SMMR.pdf}{pdf}

Weber AM, Rubio-Codina M, Walker SP, van Buuren S, Eekhout I,
Grantham-McGregor S, Caridad Araujo M, Chang SM, Fernald LCH,
Hamadani JD, Hanlon A, Karam SM, Lozoff B, Ratsifandrihamanana L,
Richter L, Black MM (2019). The D-score: a metric for interpreting
the early development of infants and toddlers across global settings.
BMJ Global Health, BMJ Global Health 4: e001724.
\href{https://gh.bmj.com/content/bmjgh/4/6/e001724.full.pdf}{pdf}.
}
\seealso{
\code{\link[=dscore]{dscore()}}
}
\keyword{datasets}
