% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsguessing.R
\name{guessattractors}
\alias{guessattractors}
\title{Guess the attractors of a model.}
\usage{
guessattractors(discretize = NULL, xlim = NULL, ylim = NULL, iters = 10,
  epsilon = NULL, stable = sqrt(.Machine$double.eps), cols = NULL)
}
\arguments{
\item{discretize}{The space between initial points. If not set, the discretization of the range
is used. May be set separately from the discretization of the range without overwriting.}

\item{xlim}{The range of x values to search for attractors. Defaults to the limits of the range.}

\item{ylim}{The range of y values to search for attractors. Defaults to the limits of the range.}

\item{iters}{The number of times the function is applied before checking the distance points have moved. Default 10.}

\item{epsilon}{The distance at which two points are considered to be the same attractor. Defaults to \code{discretize^2}.}

\item{stable}{A, usually smaller, distance at which a point is considered to have stopped moving. Defaults to \code{sqrt(.Machine$double.eps)}.}

\item{cols}{The colors of the attractors. If insufficient not provided, reasonable defaults are used. Generally (but not always) proceeds left to right, then bottom to top.}
}
\description{
Attempts to guess the attractors of a model. The space is discretized into initial points, and
repeated iteration of the model's function is used to guess the attractors. It is possible
that non-attractor fixpoints will be found by accident. The function
is iterated until the points move less than \code{stable} (default
\code{sqrt(.Machine$double.eps)}) between iterations.
The color of each point is drawn from the \code{col} parameter. If the number of poitns exceeds
the size of $\code{col}$, or $\code{col}$ is not defined, then reasonable defaults are used instead.
The attractors are \code{dspoint}s that are added to the model.
}
\examples{
model <- dsmodel(function(X0,Y0) {
list(X0*exp(2.6-X0-6.45/(1+4.5*X0)),
     Y0*exp(2.6-Y0-0.15*X0-6.25/(1+4.5*Y0)))
})

model + dsrange(5,5,0.09) + guessattractors(discretize=0.02)
}
\seealso{
\code{\link{dspoint}}

\code{\link{dsregion}}

\code{\link{dspolygon}}

\code{\link{guessregions}}
}

