% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-class-probability.R
\name{cp_pt}
\alias{cp_pt}
\title{Dataset Shift via Class Probabilities}
\usage{
cp_pt(x_train, x_test, R = 1000, num_trees = 500, sub_ratio = 1/2)
}
\arguments{
\item{x_train}{Training sample.}

\item{x_test}{Test sample.}

\item{R}{The number of permutations. May be ignored.}

\item{num_trees}{The number of trees in random forests.}

\item{sub_ratio}{Subsampling ratio for sample splitting. May be ignored.}
}
\value{
A named list or object of class \code{outlier.test} containing:
\itemize{
   \item \code{statistic}: observed WAUC statistic
   \item \code{seq_mct}: sequential Monte Carlo test, if applicable
   \item \code{p_value}: p-value
   \item \code{outlier_scores}: outlier scores from training and test set
}
}
\description{
Test for no adverse shift via class probabilities for two-sample comparison.
The scores are out-of-bag predictions from random forests with the package
\pkg{ranger}. The prefix \emph{cp} stands for class probability, whether
the instance belongs to the training or test set. The probability of
belonging to the test set is the relevant notion of outlyingness.
}
\details{
The empirical null distribution uses \code{R} permutations to estimate
the p-value. For speed, this is implemented as a sequential Monte Carlo test
with the \pkg{simctest} package. See Gandy (2009) for details. The suffix
\emph{pt} refers to permutation test. It does not use the asymptotic
(theoretical) null distribution for the weighted AUC (WAUC), the test
statistic. This is the recommended approach for small samples.
}
\section{Notes}{

Please see references for the classifier two-sample test, the
inspiration behind this approach. Note that Ciemencon et al. (2009) uses
both sample splitting for inference and the AUC, rather than the WAUC. Most
supervised method for binary classification can replace random forests, the
default in this implementation.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
x_train <- iris[1:50, 1:4] # Training sample: Species == 'setosa'
x_test <- iris[51:100, 1:4] # Test sample: Species == 'versicolor'
iris_test <- cp_at(x_train, x_test) # Can also use: cp_ss and cp_pt
str(iris_test)
}
}
\references{
Kamulete, V. M. (2021).
\emph{Test for non-negligible adverse shifts}.
arXiv preprint arXiv:2107.02990.

Ciemencon, S., Depecker, M., & Vayatis, N. (2009, December).
\emph{AUC optimization and the two-sample problem}.
In Proceedings of the 22nd International Conference on Neural Information Processing Systems (pp. 360-368).

Lopez-Paz, D., & Oquab, M. (2016).
\emph{Revisiting classifier two-sample tests}.
arXiv preprint arXiv:1610.06545.

Friedman, J. (2004).
\emph{On multivariate goodness-of-fit and two-sample testing}.

Gandy, A. (2009).
\emph{Sequential implementation of Monte Carlo tests with uniformly bounded resampling risk}.
Journal of the American Statistical Association, 104(488), 1504-1511.

Li, J., & Fine, J. P. (2010).
\emph{Weighted area under the receiver operating characteristic curve and its application to gene selection}.
Journal of the Royal Statistical Society: Series C (Applied Statistics), 59(4), 673-692.

Rinaldo, A., Wasserman, L., & G'Sell, M. (2019).
\emph{Bootstrapping and sample splitting for high-dimensional, assumption-lean inference}.
Annals of Statistics, 47(6), 3438-3469.
}
\seealso{
Other classifiers: 
\code{\link{cp_at}()},
\code{\link{cp_ss}()}
}
\concept{classifiers}
