% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsrr.R
\name{dsrr}
\alias{dsrr}
\title{Compare Directly Standardized Rates by Ratios or Differences.}
\usage{
dsrr(data, event, fu, subgroup, ..., refdata, estimate, refgroup, mp,
  sig = 0.95, decimals)
}
\arguments{
\item{data}{A data frame with counts and unit-times summarized by the standardization variables.}

\item{event}{A variable within the input data that corresponds to the event counts.}

\item{fu}{A variable within the input data that corresponds to the unit-time.}

\item{subgroup}{A variable within the input data frame for which rates are calculated by.}

\item{...}{Variables(s) within the input data that for which rates are to be standardized by. The input data and ref data should both be summarized by these.}

\item{refdata}{A data frame with population unit-times summarized by the standardization variables. The unit-time variable name must named pop.}

\item{estimate}{Choose between difference or ratio in comparing directly standardized rates.}

\item{refgroup}{A level of the subgroup variable taken to be the reference in computing rate ratios or differences.}

\item{mp}{A constant to multiply rates by (e.g. mp=1000 for rates per 1000).}

\item{sig}{The desired level of confidence in computing confidence intervals. The default is 0.95 for 95 percent CIs.}

\item{decimals}{Round estimates to a desired decimal place.}
}
\description{
Compare directly standardized rates by ratios or differences.
}
\examples{
#An example of comparing directly standardized rates
#Data from Table 1, Page 132 of Schoenbach (2000)

#State specific death counts and fu
df_study <- data.frame(state=rep(c('Miami',"Alaska"), c(5,5)),
                      age=rep(c('00-14','15-24','25-44','45-64','65+'),2),
                      deaths=c(136,57,208,1016,3605,59,18,37,90,81),
                      fu=c(114350,80259,133440,142670,92168,37164,20036,32693,14947,2077))

#US standard population
df_ref  <- data.frame(age=c('00-14','15-24','25-44','45-64','65+'),
                     pop=c(23961000,15420000,21353000,19601000,10685000))

#Directly Standardized Rate Ratio (per 1000) - 95\% log-normal CI's, Alaska as the refernce
my_results2 <- dsrr(data=df_study,
                   event=deaths,
                   fu=fu,
                   subgroup=state,
                   age,
                   refdata=df_ref,
                   refgroup="Alaska",
                   estimate="ratio",
                   sig=0.95,
                   mp=1000,
                   decimals=4)
#View results
my_results2
}
\references{
Fay, M.P., & Feuer, E.J. (1997). Confidence intervals for directly standardized rates: a method based on the gamma distribution. Statistics in Medicine,16, 791-801.

Elandt-Johnson, R. C., and Johnson, N. L. (1980). Survival Models and Data Analysis. New York: John Wiley & Sons.

Chiang C. Standard error of the age-adjusted death rate. US Department of Health, Education and Welfare: Vital Statistics Special Reports 1961;47:271-285.

Schoenbach, V., and Rosamond W. (2000) Understanding the fundamentals of epidemiology: An evolving text.
}
