% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_dtlg.R
\name{print_dtlg}
\alias{print_dtlg}
\title{Print a \code{dtlg} table}
\usage{
print_dtlg(
  dt,
  row.names = FALSE,
  trunc.cols = TRUE,
  class = FALSE,
  nrows = Inf,
  justify = "left"
)
}
\arguments{
\item{dt}{A \code{dtlg} table, typically a \code{data.frame} or \code{data.table}.}

\item{row.names}{ If \code{TRUE}, row indices will be printed alongside \code{x}. }

\item{trunc.cols}{ If \code{TRUE}, only the columns that can be printed in the console without wrapping the columns to new lines will be printed (similar to \code{tibbles}). }

\item{class}{ If \code{TRUE}, the resulting output will include above each column its storage class (or a self-evident abbreviation thereof). }

\item{nrows}{ The number of rows which will be printed before truncation is enforced. }

\item{justify}{String. Column alignment; one of \code{"left"}, \code{"right"},
\code{"centre"}, or \code{"none"}. Defaults to \code{"left"}.}
}
\value{
Invisibly returns the printed object.
}
\description{
A convenience wrapper around \code{\link[=print]{print()}} for printing \code{dtlg} tables with
consistent formatting options.
}
\examples{
calc_stats(dt = adsl, "AGE", treat = "ARM", indent = "  ")[[1]] |>
  print_dtlg()

}
