% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_idp_admin0_data.R
\name{get_idp_admin0_data}
\alias{get_idp_admin0_data}
\title{Fetch IDP Admin0 Data}
\usage{
get_idp_admin0_data(
  Operation = NULL,
  CountryName = NULL,
  Admin0Pcode = NULL,
  FromReportingDate = NULL,
  ToReportingDate = NULL,
  FromRoundNumber = 0,
  ToRoundNumber = 0
)
}
\arguments{
\item{Operation}{Optional; Name of the DTM operation for which the data was collected.}

\item{CountryName}{Optional; Name of the country where the data was collected.}

\item{Admin0Pcode}{Optional; Country code (ISO 3166-1 alpha-3).}

\item{FromReportingDate}{Optional; Start date for the reporting period (format: 'YYYY-MM-DD').}

\item{ToReportingDate}{Optional; End date for the reporting period (format: 'YYYY-MM-DD').}

\item{FromRoundNumber}{Optional; Starting round number for the data collection range.}

\item{ToRoundNumber}{Optional; Ending round number for the data collection range.}
}
\value{
A data frame containing the IDP Admin0 data matching the specified criteria.
}
\description{
Retrieve IDP data at Admin 0 level based on specified parameters.
At least one of the following parameters must be provided: Operation, CountryName, or Admin0Pcode.
}
\examples{
# Fetch IDP data at Admin Level 0
idp_admin0_df <- get_idp_admin0_data(CountryName='Ethiopia', FromRoundNumber=1, ToRoundNumber=10)
head(idp_admin0_df)
}
