% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-mutate.R
\name{mutate.dtplyr_step}
\alias{mutate.dtplyr_step}
\title{Create and modify columns}
\usage{
\method{mutate}{dtplyr_step}(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\link[dplyr:dplyr_data_masking]{data-masking}> Name-value pairs.
The name gives the name of the column in the output, and the value should
evaluate to a vector.}

\item{.before, .after}{\Sexpr[results=rd]{lifecycle::badge("experimental")}
<\code{\link[=dplyr_tidy_select]{tidy-select}}> Optionally, control where new columns
should appear (the default is to add to the right hand side). See
\code{\link[=relocate]{relocate()}} for more details.}
}
\description{
This is a method for the dplyr \code{\link[=mutate]{mutate()}} generic. It is translated to
the \code{j} argument of \verb{[.data.table}, using \verb{:=} to modify "in place". If
\code{.before} or \code{.after} is provided, the new columns are relocated with a call
to \code{\link[data.table:setcolorder]{data.table::setcolorder()}}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(data.frame(x = 1:5, y = 5:1))
dt \%>\%
  mutate(a = (x + y) / 2, b = sqrt(x^2 + y^2))

# It uses a more sophisticated translation when newly created variables
# are used in the same expression
dt \%>\%
  mutate(x1 = x + 1, x2 = x1 + 1)
}
