% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_bind_rows}
\alias{p_bind_rows}
\title{Union of two or more data sets}
\usage{
p_bind_rows(
  ...,
  .id = NULL,
  .messages = "{.count.out} in union",
  .headline = "Union"
)
}
\arguments{
\item{...}{the data frames to bind}

\item{.id}{Data frame identifier.

When \code{.id} is supplied, a new column of identifiers is
created to link each row to its original data frame. The labels
are taken from the named arguments to \code{bind_rows()}. When a
list of data frames is supplied, the labels are taken from the
names of the list. If no names are found a numeric sequence is
used instead.}

\item{.messages}{\itemize{
\item a set of glue specs. The glue code can use any global variable, or \{.count.out\}
}}

\item{.headline}{\itemize{
\item a glue spec. The glue code can use any global variable, or \{.count.out\}
}}
}
\value{
the logical union of the dataframes with the history graph updated.
}
\description{
This merges the history of 2 dataframes and binds the rows. It calculates the total number of resulting rows as {.count.out}
in other terms it performs exactly the same operation as dplyr::bind_rows. See \code{\link[dplyr:bind]{dplyr::bind_rows()}}.
}
\examples{
library(dplyr)
bind_rows( iris \%>\% comment("one"), iris \%>\% comment("two") ) \%>\% history()
}
\seealso{
dplyr::bind_rows()
}
