% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hour-decimal.R
\name{dtt_hour_decimal}
\alias{dtt_hour_decimal}
\alias{dtt_hour_decimal.Date}
\alias{dtt_hour_decimal.POSIXct}
\alias{dtt_hour_decimal.hms}
\title{Get Decimal Hour Values}
\usage{
dtt_hour_decimal(x, ...)

\method{dtt_hour_decimal}{Date}(x, ...)

\method{dtt_hour_decimal}{POSIXct}(x, ...)

\method{dtt_hour_decimal}{hms}(x, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}
}
\value{
A numeric vector.
}
\description{
Gets decimal hour values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_hour_decimal(Date)}: Get numeric vector of decimal hour values for a Date vector

\item \code{dtt_hour_decimal(POSIXct)}: Get numeric vector of decimal hour values for a POSIXct vector

\item \code{dtt_hour_decimal(hms)}: Get numeric vector of decimal hour values for a hms vector

}}
\examples{
x <- as.POSIXct("1990-01-02 23:40:51")
dtt_hour_decimal(x)
x <- hms::as_hms("23:40:51")
dtt_hour_decimal(x)
}
\seealso{
\code{\link[=dtt_hour]{dtt_hour()}}

Other decimal: 
\code{\link{dtt_day_decimal}()},
\code{\link{dtt_doy_decimal}()},
\code{\link{dtt_minute_decimal}()},
\code{\link{dtt_month_decimal}()},
\code{\link{dtt_year_decimal}()}
}
\concept{decimal}
