% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{df_from_file}
\alias{df_from_file}
\alias{duckplyr_df_from_file}
\title{Read Parquet, CSV, and other files using DuckDB}
\usage{
df_from_file(path, table_function, options = list(), class = NULL)

duckplyr_df_from_file(path, table_function, options = list(), class = NULL)
}
\arguments{
\item{path}{Path to file or directory}

\item{table_function}{The name of a table-valued
DuckDB function such as \code{"read_parquet"},
\code{"read_csv"}, \code{"read_csv_auto"} or \code{"read_json"}.}

\item{options}{Arguments to the DuckDB function
indicated by \code{table_function}.}

\item{class}{An optional class to add to the data frame.
The returned object will always be a data frame.
Pass \code{class(tibble())} to create a tibble.}
}
\value{
A data frame for \code{df_from_file()}, or a \code{duckplyr_df} for
\code{duckplyr_df_from_file()}, extended by the provided \code{class}.
}
\description{
This function ingests data from files.
Internally, a DuckDB table-valued function is called,
the results are transparently converted to a data frame.
The data is only read when the data is actually accessed.
See \url{https://duckdb.org/docs/data/overview} for a documentation
of the available functions and their options.

\code{duckplyr_df_from_file()} is a thin wrapper around \code{df_from_file()}
that calls \code{as_duckplyr_df()} on the output.
}
\examples{
# Create simple CSV file
path <- tempfile(fileext = ".csv")
write.csv(data.frame(a = 1:3, b = letters[4:6]), path, row.names = FALSE)

# Reading is immediate
df <- df_from_file(path, "read_csv_auto")

# Materialization only upon access
names(df)
df$a

# Return as tibble:
df_from_file(
  path,
  "read_csv",
  options = list(delim = ",", auto_detect = TRUE),
  class = class(tibble())
)

unlink(path)
}
