# Generated by 02-duckplyr_df-methods.R
#' @export
group_indices.duckplyr_df <- function(.data, ...) {
  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for group_indices()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  group_indices <- dplyr$group_indices.data.frame
  out <- group_indices(.data, ...)
  return(out)

  # dplyr implementation
  if (dots_n(...) > 0) {
    lifecycle::deprecate_warn(
      "1.0.0", "group_indices(... = )",
      details = "Please `group_by()` first",
      always = TRUE
    )
    .data <- group_by(.data, ...)
  }

  # .Call(`dplyr_group_indices`, .data, group_rows(.data))
}

duckplyr_group_indices <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_indices(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
