% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_modify_row.R
\name{dct_modify_row}
\alias{dct_modify_row}
\title{Modify row(s) of a taxonomic database}
\usage{
dct_modify_row(
  tax_dat,
  taxonID = NULL,
  scientificName = NULL,
  taxonomicStatus = NULL,
  acceptedNameUsageID = NULL,
  acceptedNameUsage = NULL,
  clear_usage_id = dct_options()$clear_usage_id,
  clear_usage_name = dct_options()$clear_usage_name,
  fill_usage_name = dct_options()$fill_usage_name,
  remap_names = dct_options()$remap_names,
  remap_variant = dct_options()$remap_variant,
  stamp_modified = dct_options()$stamp_modified,
  strict = dct_options()$strict,
  quiet = dct_options()$quiet,
  args_tbl = NULL,
  ...
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{taxonID}{Character or numeric vector of length 1; taxonID of the row
to be modified (the selected row).}

\item{scientificName}{Character vector of length 1; scientificName of the row
to be modified if \code{taxonID} is \code{NULL}, OR the scientificName to assign to the
selected row if \code{taxonID} is provided (see Details).}

\item{taxonomicStatus}{Character vector of length 1; taxonomicStatus to
assign to the selected row.}

\item{acceptedNameUsageID}{Character or numeric vector of length 1;
acceptedNameUsageID to assign to the selected row.}

\item{acceptedNameUsage}{Character vector of length 1; acceptedNameUsage to
assign to the selected row.}

\item{clear_usage_id}{Logical vector of length 1; should acceptedNameUsageID of the selected row be set to \code{NA} if the word "accepted" is detected in tax_status (not case-sensitive)? Default \code{TRUE}.}

\item{clear_usage_name}{Logical vector of length 1; should acceptedNameUsageID of the selected row be set to \code{NA} if the word "accepted" is detected in tax_status (not case-sensitive)? Default \code{TRUE}.}

\item{fill_usage_name}{Logical vector of length 1; should the acceptedNameUsage of the selected row be set to the scientificName corresponding to its acceptedNameUsageID? Default \code{TRUE}.}

\item{remap_names}{Logical vector of length 1; should the acceptedNameUsageID be updated (remapped) for rows with the same acceptedNameUsageID as the taxonID of the row to be modified? Default \code{TRUE}.}

\item{remap_variant}{Same as \code{remap_names}, but applies specifically to rows with taxonomicStatus of "variant". Default \code{FALSE}.}

\item{stamp_modified}{Logical vector of length 1; should the \code{modified} column of any newly created or modified row include a timestamp with the date and time of its creation/modification? If the \code{modified} column does not yet exist it will be created. Default \code{TRUE}.}

\item{strict}{Logical vector of length 1; should taxonomic checks be run on the updated taxonomic database? Default \code{FALSE}..}

\item{quiet}{Logical vector of length 1; should warnings be silenced? Default \code{FALSE}..}

\item{args_tbl}{A dataframe including columns corresponding to one or more of
the above arguments, except for \code{tax_dat}. In this case, the input taxonomic
database will be modified sequentially over each row of input in \code{args_tbl}.
Other DwC terms can also be included as additional columns,
similar to using \code{...} to modify a single row.}

\item{...}{other DwC terms to modify, specified as sets of named values.
Each element of the vector must have a name corresponding to a valid
DwC term; see \link{dct_terms}.}
}
\value{
Dataframe; taxonomic database in DwC format
}
\description{
Modify one or more rows in a taxonomic database in Darwin Core (DwC) format.
}
\details{
\code{taxonID} is only used to identify the row(s) to modify and is not itself
modified. \code{scientificName} can be used in the same way if \code{taxonID} is not
provided (as long as \code{scientificName} matches a single row). If both
\code{taxonID} and \code{scientificName} are provided, \code{scientificName} will be
assigned to the scientificName of the row identified by \code{taxonID}, replacing
any value that already exists.

\code{acceptedNameUsageID} and \code{acceptedNameUsage} must match existing values of
acceptedNameUsageID and acceptedNameUsage in the input data (\code{tax_dat}). On
default settings, either can be used and the other will be filled in
automatically (\code{fill_usage_id} and \code{fill_usage_name} are both \code{TRUE}).

Any other arguments provided that are DwC terms will be assigned to the
selected row (i.e., they will modify the row).

If \code{remap_names} is \code{TRUE} (default) and \code{acceptedNameUsageID} is provided,
any names that have an acceptedNameUsageID matching the taxonID of the
selected row (i.e., synonyms of that row) will also have their
acceptedNameUsageID replaced with the new acceptedNameUsageID. This behavior
is not applied to names with taxonomicStatus of "variant" by default, but can
be turned on for such names with \code{remap_variant}.

If \code{clear_usage_id} or \code{clear_usage_name} is \code{TRUE} and \code{taxonomicStatus}
includes the word "accepted", acceptedNameUsageID
or acceptedNameUsage will be set to NA respectively, regardless of the
values of \code{acceptedNameUsageID}, \code{acceptedNameUsage}, or \code{fill_usage_name}.

Can either modify a single row in the input taxonomic database if each
argument is supplied as a vector of length 1, or can apply a set of changes
to the taxonomic database if the input is supplied as a dataframe via
\code{args_tbl}.
}
\examples{
# Swap the accepted / synonym status of
# Cephalomanes crassum (Copel.) M. G. Price
# and Trichomanes crassum Copel.
dct_filmies |>
  dct_modify_row(
    scientificName = "Cephalomanes crassum (Copel.) M. G. Price",
    taxonomicStatus = "synonym",
    acceptedNameUsage = "Trichomanes crassum Copel."
  ) |>
  dct_modify_row(
    scientificName = "Trichomanes crassum Copel.",
    taxonomicStatus = "accepted"
  ) |>
  dct_validate(
    check_tax_status = FALSE,
    check_mapping_accepted_status = FALSE,
    check_sci_name = FALSE
  )
# Sometimes changing one name will affect others, if they map
# to the new synonym
dct_modify_row(
  tax_dat = dct_filmies |> head(),
  scientificName = "Cephalomanes crassum (Copel.) M. G. Price",
  taxonomicStatus = "synonym",
  acceptedNameUsage = "Cephalomanes densinervium (Copel.) Copel."
)
# Apply a set of changes
library(tibble)
updates <- tibble(
  scientificName = c(
    "Cephalomanes atrovirens Presl",
    "Cephalomanes crassum (Copel.) M. G. Price"
  ),
  taxonomicStatus = "synonym",
  acceptedNameUsage = "Trichomanes crassum Copel."
)
dct_filmies |>
  dct_modify_row(args_tbl = updates) |>
  dct_modify_row(
    scientificName = "Trichomanes crassum Copel.",
    taxonomicStatus = "accepted"
  )
}
