% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLE_dirichlet.R
\name{MLE_dirichlet}
\alias{MLE_dirichlet}
\title{Estimate the parameter of a Dirichlet distribution}
\usage{
MLE_dirichlet(probs, alpha0 = rep(1, ncol(probs)))
}
\arguments{
\item{probs}{a matrix with N rows representing observations of probability
vectors and K columns representing the classes. Therefore, values of each row
should sum to 1.}

\item{alpha0}{vector of K=ncol(probs) values as starting parameter for the optimization.
Values have to be greater 0.}
}
\value{
Returns a numeric vector of length K=ncol(probs) representing the
\eqn{\alpha}{\alpha} of the Dirichlet distribution.
}
\description{
The function \code{MLE_dirichlet} performs a maximum-likelihood estimation of the
\eqn{\alpha}{\alpha} parameter of a Dirichlet distribution for a given sample of
probability vectors.
}
\details{
The density of the Dirichlet distribution for
\eqn{\alpha = (\alpha_1, ..., \alpha_K )} and
\eqn{\alpha_i > 0 \forall i=1,...,K} is given by
\deqn{f(p|\alpha)=\frac{1}{B(\alpha)} \prod_{i=1}{K} p_{i}^{\alpha_i - 1},}
if \eqn{0\leq p_i \leq 1 \forall i = 1,...,K} and \eqn{\sum_{i=1}^{K} p_i ) 1},
and \eqn{f(p|\alpha) = 0}, else.

The function optimizes the log-likelihood of a sample of probability vectors
given in \code{probs} using the function \code{\link{optim}} and a Nelder-Mead
algorithm.
}
\examples{
probs <- matrix(c(0.2, 0.4, 0.2, 0.4, 0, 0.2, 0.4, 0.4, 0.6, 0.2, 0.2,
                  0.4, 0.4, 0.2, 0.2, 0.4, 0.8, 0.4), ncol=3)
MLE_dirichlet(probs)
}
\author{
Sebastian Hellmann.
}
