/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.KeyedObject;
import org.jfree.util.PublicCloneable;

public class KeyedObjects
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1321582394193530984L;
    private List<KeyedObject> data = new ArrayList<KeyedObject>();

    public int getItemCount() {
        return this.data.size();
    }

    public Object getObject(int item) {
        KeyedObject kobj;
        Object result = null;
        if (item >= 0 && item < this.data.size() && (kobj = this.data.get(item)) != null) {
            result = kobj.getObject();
        }
        return result;
    }

    public Comparable getKey(int index) {
        KeyedObject item;
        Comparable result = null;
        if (index >= 0 && index < this.data.size() && (item = this.data.get(index)) != null) {
            result = item.getKey();
        }
        return result;
    }

    public int getIndex(Comparable key) {
        int result = -1;
        int i = 0;
        for (KeyedObject ko : this.data) {
            if (ko.getKey().equals(key)) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public List getKeys() {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        for (KeyedObject ko : this.data) {
            result.add(ko.getKey());
        }
        return result;
    }

    public Object getObject(Comparable key) {
        return this.getObject(this.getIndex(key));
    }

    public void addObject(Comparable key, Object object) {
        this.setObject(key, object);
    }

    public void setObject(Comparable key, Object object) {
        int keyIndex = this.getIndex(key);
        if (keyIndex >= 0) {
            KeyedObject ko = this.data.get(keyIndex);
            ko.setObject(object);
        } else {
            KeyedObject ko = new KeyedObject(key, object);
            this.data.add(ko);
        }
    }

    public void removeValue(int index) {
        this.data.remove(index);
    }

    public void removeValue(Comparable key) {
        this.removeValue(this.getIndex(key));
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects clone = (KeyedObjects)super.clone();
        clone.data = new ArrayList<KeyedObject>();
        for (KeyedObject ko : this.data) {
            clone.data.add((KeyedObject)ko.clone());
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyedObjects)) {
            return false;
        }
        KeyedObjects kos = (KeyedObjects)o;
        int count = this.getItemCount();
        if (count != kos.getItemCount()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Comparable k2;
            Comparable k1 = this.getKey(i);
            if (!k1.equals(k2 = kos.getKey(i))) {
                return false;
            }
            Object o1 = this.getObject(i);
            Object o2 = kos.getObject(i);
            if (o1 == null ? o2 != null : !o1.equals(o2)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

