/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHist;
import jas.hist.SaveAsPlugin;
import jas.util.FileTypeFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class SaveAsPlotML
implements SaveAsPlugin {
    private JRadioButton button1 = new JRadioButton("Save current snapshot of data", true);
    private JRadioButton button2 = new JRadioButton("Save reference to live data");

    public boolean hasOptions() {
        return true;
    }

    public FileFilter getFileFilter() {
        return new FileTypeFileFilter("plotml", "XML Plot File (*.plotml)");
    }

    public JPanel getOptionsPanel() {
        JPanel custom = new JPanel();
        custom.add(this.button1);
        custom.add(this.button2);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.button1);
        bg.add(this.button2);
        return custom;
    }

    public void saveAs(Component c, OutputStream os, File file, Component dialogParent) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        ((JASHist)c).writeXML(writer, this.button1.isSelected());
        ((Writer)writer).close();
    }

    public File adjustFilename(File file) {
        String name = file.getName();
        if (name.endsWith(".plotml")) {
            return file;
        }
        int pos = name.indexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        name = name + ".plotml";
        File parent = file.getParentFile();
        return new File(parent, name);
    }

    public boolean supportsClass(Object o) {
        return o instanceof JASHist;
    }

    public void restoreOptions(Properties props) {
    }

    public void saveOptions(Properties props) {
    }
}

