/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateDayModel;
import jas.util.DateModel;
import jas.util.DateMonthModel;
import jas.util.DateYearModel;
import jas.util.MonthCellRenderer;
import jas.util.YearCellRenderer;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class CalendarHeader
extends JComponent {
    private DateModel model;

    CalendarHeader(DateModel model) {
        this.model = model;
        int offset = 1950;
        this.setLayout(new FlowLayout());
        JComboBox day = new JComboBox(new DateDayModel(model));
        JComboBox<Object> month = new JComboBox<Object>(new DateMonthModel(model));
        JComboBox<Object> year = new JComboBox<Object>(new DateYearModel(model, offset));
        month.setRenderer(new MonthCellRenderer());
        year.setRenderer(new YearCellRenderer(offset));
        JButton down = new JButton("<");
        JButton up = new JButton(">");
        down.addActionListener(new RollListener(-1));
        up.addActionListener(new RollListener(1));
        this.add(down);
        this.add(day);
        this.add(month);
        this.add(year);
        this.add(up);
    }

    private class RollListener
    implements ActionListener {
        private int delta;

        RollListener(int delta) {
            this.delta = delta;
        }

        public void actionPerformed(ActionEvent evt) {
            CalendarHeader.this.model.add(2, this.delta);
        }
    }
}

