% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatiotemp_thin.R
\name{spatiotemp_thin}
\alias{spatiotemp_thin}
\title{Thin species occurrence records by spatial and temporal proximity.}
\usage{
spatiotemp_thin(
  occ.data,
  temporal.method,
  temporal.dist,
  spatial.split.degrees,
  spatial.dist = 0,
  iterations = 100
)
}
\arguments{
\item{occ.data}{a data frame, with columns for occurrence record co-ordinates and dates with
column names as follows; record longitude as "x", latitude as "y", year as "year", month as
"month", and day as "day".}

\item{temporal.method}{a character string, the method to calculate temporal distance between
records. One of \code{DOY} or \code{day.} See details for more information.}

\item{temporal.dist}{a numeric value, the temporal buffer in days to thin records by.}

\item{spatial.split.degrees}{a numeric value, the grid cell resolution in degrees to split
occurrence records by before temporal thinning.}

\item{spatial.dist}{a numeric value, the spatial buffer distances in metres to thin records by.
Default no spatial thinning.}

\item{iterations}{a numeric value, the number of iterations to randomly thin occurrence records
by. Default; 100.}
}
\value{
Returns data frame of occurrence records thinned by specified temporal and spatial
distance.
}
\description{
Thins species occurrence records that are within minimum spatial and temporal distance apart.
}
\section{Overview}{
\code{spatiotemp_thin()} calculates the temporal distance between occurrence records in given area
and excludes records below minimum temporal distance apart. Then calculates the spatial distance
between all occurrence records and filters records below the minimum spatial distance apart using
the \code{spThin} package function for spatial thinning (Aiello-Lammens et al., 2015). This approach
has been shown to improve species distribution model performance (Boria et al., 2014).
}

\section{Temporal thinning methods}{
For temporal thinning, the function first splits occurrence records into grid cells of given size
in degrees (set by \code{spatial.split.degrees}). This is to prevent spatially distant but temporally
close records from being excluded. For each grid cell, all records within the cell are temporally
thinned. This process works by removing records that are within given temporal distance
(\code{temporal.dist}) from each other by randomly selecting one of the two. This iterates through
until no records are within the given temporal distance of each other in each grid cell, following
a similar algorithm to \code{spThin} (Aiello-Lammens et al., 2015).

Two methods exist for measuring the temporal distance between occurrence records.
\itemize{
\item 
\enumerate{
\item \code{doy} - calculates the minimum days apart within the annual cycle
}
\item 
\enumerate{
\item \code{day} - uses the absolute number of days.
}
}

For instance, two dates “2010-01-05” and “2012-12-05” can be calculated as either 1065 absolute
days apart, or within the annual cycle these dates represent day 5 and day 339 of the year, and
are 31 days apart. Therefore, thinning by 40 days using the \code{DOY} method would remove one of these
records, but using the \code{day} method would not. The chosen \code{temporal.method} will depend upon
whether bias towards a point within the annual cycle or a point in linear time.
}

\section{Spatial thinning}{
Following temporal thinning, spatial thinning occurs across entire dataset. The spatial distance
between each record is calculated, and records within the given spatial distance (\code{spatial.dist})
from each other are excluded by randomly selecting one of these. This iterates through until no
records are with the given spatial distances of each other across entire dataset using the package
\code{spThin} (Aiello-Lammens et al., 2015).

As random selection could alter the total number of occurrence records remaining in the occurrence
record dataset, this process is iterated through a specified number of times (\code{iterations}) and
the thinned data frame with the highest number of records remaining is returned.
}

\examples{

data("sample_filt_data")

n.iterations <- 500
\donttest{
spatiotemp_thin(
 occ.data = sample_filt_data,
 temporal.method = "day",
 temporal.dist = 100,
 spatial.split.degrees = 3,
 spatial.dist = 100000,
 iterations = n.iterations
)
}
}
\references{
Aiello-Lammens, M. E., Boria, R. A., Radosavljevic, A., Vilela, B. & Anderson, R. P.
2015. spThin: an R package for spatial thinning of species occurrence records for use in
ecological niche models. Ecography, 38, 541-545.

Boria, R. A., Olson, L. E., Goodman, S. M. & Anderson, R. P. 2014. Spatial Filtering To Reduce
Sampling Bias Can Improve The Performance Of Ecological Niche Models. Ecological Modelling, 275,
73-77.
}
