% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{get_cloud_quantiles}
\alias{get_cloud_quantiles}
\alias{get_cloud_quantiles.PF_EM}
\alias{get_cloud_quantiles.PF_clouds}
\title{Compute Quantile Estimates from Particle Cloud}
\usage{
get_cloud_quantiles(object, ...)

\method{get_cloud_quantiles}{PF_EM}(object, ...)

\method{get_cloud_quantiles}{PF_clouds}(object, cov_index = NULL,
  qlvls = c(0.05, 0.5, 0.95), type = c("smoothed_clouds", "forward_clouds",
  "backward_clouds"), ...)
}
\arguments{
\item{object}{object with class \code{PF_EM} or \code{PF_clouds}.}

\item{...}{named arguments to pass to the \code{PF_clouds} method.}

\item{cov_index}{integer vector with indices of the random effect to
include.}

\item{qlvls}{numeric vector with values in \eqn{[0,1]} with the quantiles to
compute.}

\item{type}{character with the type of cloud to compute quantiles for.}
}
\value{
A 3 dimensional array where the first dimension is the quantiles, the second
dimension is the random effect, and the third dimension is the time.
}
\description{
Computes the estimated quantiles from a particle cloud.
}
