% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglike.R
\name{logLik.ddhazard}
\alias{logLik.ddhazard}
\title{Log Likelihood of Mean Path of ddhazard Object}
\usage{
\method{logLik}{ddhazard}(object, data = NULL, id, ...)
}
\arguments{
\item{object}{an object of class \code{ddhazard}.}

\item{data}{new data to evaluate the likelihood for.}

\item{id}{the individual identifiers as in \code{\link{ddhazard}}.}

\item{...}{unused.}
}
\value{
Returns an ojbect of class \code{logLik}. See \code{\link{logLik}}.
}
\description{
Computes the log likelihood of (a potentially new) data set given the estimated:
\deqn{E_{\theta}(\alpha_1 | y_{1:d}), E_{\theta}(\alpha_{2} | y_{1:d}), ..., E_{\theta}(\alpha_{d} | y_{1:d})}

of the \code{ddhazard} object. Note that this is not the log likelihood of the observed data given the outcome.
}
\examples{
library(dynamichazard)
fit <- ddhazard(
 Surv(time, status == 2) ~ log(bili), pbc, id = pbc$id, max_T = 3600,
 Q_0 = diag(1, 2), Q = diag(1e-4, 2), by = 50,
 control = ddhazard_control(method = "GMA"))
logLik(fit)

}
