% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_diagnostics.R
\name{mcmc_diagnostics}
\alias{mcmc_diagnostics}
\alias{mcmc_diagnostics.dynamitefit}
\title{Diagnostic Values of a Dynamite Model}
\usage{
mcmc_diagnostics(x, n)

\method{mcmc_diagnostics}{dynamitefit}(x, n = 3L)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{n}{[\code{integer(1)}]\cr How many rows to print in
parameter-specific convergence measures. The default is 3. Should be a
positive (unrestricted) integer.}
}
\value{
Returns \code{x} (invisibly).
}
\description{
Prints HMC diagnostics, and lists parameters with smallest effective sample
sizes and largest Rhat values. See \code{\link[rstan:check_hmc_diagnostics]{rstan::check_hmc_diagnostics()}} and
\code{\link[posterior:draws_summary]{posterior::default_convergence_measures()}} for details.
}
\examples{
data.table::setDTthreads(1) # For CRAN
mcmc_diagnostics(gaussian_example_fit)

}
\seealso{
Model diagnostics
\code{\link{lfo}()},
\code{\link{loo.dynamitefit}()}
}
\concept{diagnostics}
