% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.dynamitefit}
\alias{coef.dynamitefit}
\title{Extract Regression Coefficients of a Dynamite Model}
\usage{
\method{coef}{dynamitefit}(
  object,
  types = c("alpha", "beta", "delta"),
  parameters = NULL,
  responses = NULL,
  times = NULL,
  groups = NULL,
  summary = TRUE,
  probs = c(0.05, 0.95),
  ...
)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{types}{[\code{character()}]\cr Type(s) of the parameters for which the
samples should be extracted. See details of possible values. Default is
all values listed in details except spline coefficients \code{omega}.
This argument is mutually exclusive with \code{parameters}.}

\item{parameters}{[\code{character()}]\cr Parameter(s) for which the samples
should be extracted. Possible options can be found with function
\code{get_parameter_names()}. Default is all parameters of specific type for
all responses. This argument is mutually exclusive with \code{types}.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.
Ignored if the argument \code{parameters} is supplied.
\code{omega_alpha}, and \code{omega_psi}. See also \code{\link[=get_parameter_types]{get_parameter_types()}}.}

\item{times}{[\code{double()}]\cr Time point(s) to keep. If \code{NULL}
(the default), all time points are kept.}

\item{groups}{[\code{character()}] Group name(s) to keep. If \code{NULL}
(the default), all groups are kept.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE} (default), returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE}, returns the
posterior samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{...}{Ignored.}
}
\value{
A \code{tibble} containing either samples or summary statistics of the
model parameters in a long format.
}
\description{
Extracts either time-varying or time-invariant parameters of the model.
}
\examples{
data.table::setDTthreads(1) # For CRAN
betas <- coef(gaussian_example_fit, type = "beta")
deltas <- coef(gaussian_example_fit, type = "delta")

}
\seealso{
Model outputs
\code{\link{as.data.frame.dynamitefit}()},
\code{\link{as.data.table.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_names}()},
\code{\link{get_parameter_types}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
