% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_layers.R
\name{build_layers}
\alias{build_layers}
\title{Construct basic landscape layer data for Dynamic TOPMODEL run}
\usage{
build_layers(dem, fill.sinks = TRUE, deg = 0.1)
}
\arguments{
\item{dem}{Elevation raster using a projected coordinate system (e.g UTM) and regular grid spacing. Should have a resolution of a least 30m for the TWI to be meaningful.}

\item{fill.sinks}{If TRUE (default) then run a sinkfill before calculating the upslope area and TWI.}

\item{deg}{Threshold intercell slope to determine sinks (degrees).}
}
\value{
A multi-band raster (stack) comprising, in order, the elevations, upslope area and topographic wetness index values.
}
\description{
Given an elevation raster this function will create a basic multi-band raster that can be used to run Dynamic TOPMODEL after applying a suitable discretisation.
It comprises the supplied elevations with the addition of upslope contributing area and topographic wetness index (TWI).
}
\examples{
\dontrun{
require(dynatopmodel)
data("brompton")

# Upslope area and wetness index for Brompton catchment
layers <- build_layers(brompton$dem)

sp::plot(layers, main=c("Elevation AMSL (m)", "Upslope area (log(m^2/m))", "TWI ((log(m^2/m))"))
}
}
\author{
Peter Metcalfe
}
