% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_tf_network.R
\name{generate_tf_network}
\alias{generate_tf_network}
\alias{tf_network_default}
\title{Generate a transcription factor network from the backbone}
\usage{
generate_tf_network(model)

tf_network_default(
  min_tfs_per_module = 1L,
  sample_num_regulators = function() 2,
  weighted_sampling = FALSE
)
}
\arguments{
\item{model}{A dyngen initial model created with \code{\link[=initialise_model]{initialise_model()}}.}

\item{min_tfs_per_module}{The number of TFs to generate per module in the backbone.}

\item{sample_num_regulators}{A function to generate the number of TFs per module each TF will be regulated by.}

\item{weighted_sampling}{When determining what TFs another TF is regulated by, whether to perform weighted
sampling (by rank) or not.}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_tf_network]{generate_tf_network()}} generates the transcription factors (TFs) that
drive the dynamic process a cell undergoes.
\code{\link[=tf_network_default]{tf_network_default()}} is used to configure parameters pertaining this process.
}
\examples{
model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    tf_network = tf_network_default(min_tfs_per_module = 1L)
  ) \%>\%
  generate_tf_network()
  
plot_feature_network(model)
  
\donttest{
model <- model \%>\%
  generate_feature_network() \%>\%
  generate_kinetics() \%>\%
  generate_gold_standard() \%>\%
  generate_cells() \%>\%
  generate_experiment()
  
dataset <- wrap_dataset(model)
}

}
