% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrTaste.R
\name{dynr.taste}
\alias{dynr.taste}
\title{Detect outliers in state space models.}
\usage{
dynr.taste(dynrModel, dynrCook = NULL, which.state, which.obs,
  conf.level = 0.99, alternative = c("two.sided", "less", "greater"),
  debug_flag = FALSE)
}
\arguments{
\item{dynrModel}{an object of `dynrModel' class.}

\item{dynrCook}{the `dynrCook' object fitted with `debug_flag=TRUE' for the `dynrModel' object. The default is NULL.
If the dynrCook object were not provided, or the object were cooked
with `debug_flag=FALSE',
\code{dynr.taste} will fit the dynrModel object with `debug_flag=TRUE' internally.}

\item{which.state}{a character vector of the names of latent variables. 
The outlier detection process will be applied only to the chosen variable. 
If the argument is NA, all the latent variables will be excluded in the outlier detection process. 
If the argument is missing (defalut), all the latent variables will be chosen.}

\item{which.obs}{a character vector of the names of measured or observed variables.
The outlier detection process will be applied only to the chosen variable. 
If the argument is NA, all the measured variables will be excluded in the outlier detection process. 
If the argument is missing (defalut), all the measured variables will be chosen.}

\item{conf.level}{a numeric of confidence level that is used for
outliers detection tests (chi-square test and t-test). The default is 0.99.}

\item{alternative}{a character string specifying the alternative hypothesis of t-test,
must be one of ``two.sided'' (default), ``greater''  or ``less''.}

\item{debug_flag}{a logical. 'TRUE' for output of by-products related to t-value calculation}
}
\value{
an object of `dynrTaste' class
that is a list containing lists of results from the outlier detection process.
Vectors of ID and measured time points are included for later use,
such as in dynr.taste2.
The values, p-values, and shock points related to 
`joint' chi-square, `independent' chi-square, and t statistic
for innovative and additive outliers are following in that order.
The estimated delta for innovative and additive components are in the last.
If \code{debug_flag} is \code{TRUE}, 
The by-products of the Kalman filter and smoother (Q, S, s, F_inv, N, u, r) would be added at the end.
See the reference for definition of the notations.
The t statistic (estimate of an outlier divided by standard error of the outlier) of the last time point is NA, 
because the Kalman smoothing process starts with setting r and N to zero for the last time point 
(core elements of calculating estimates and the standard errors of outliers) 
that lead to 0/0 of the t statistic of the last time point.
For the time-varing models, more NAs would appear at the end of times because the Kalman smoother needs more time points to obtain all elements of r nad N from limited number of observed variables in the model. 

The `delta_chi' list comprises magnitude of innovative (Latent) and additive (Observed) outliers, `delta.L' and `delta.O',
when chi-square statitics is used to detect outliers.
The `delta_t' list comprises magnitude of innovative (Latent) and additive (Observed) outliers, `delta.L' and `delta.O',
when t statitics is used to detect outliers.
}
\description{
Compute shocks and chi-squared diagnostics following
Chow, Hamaker, and Allaire (2009).  Using Innovative Outliers to
Detect Discrete Shifts in Dynamics in Group-Based State-Space Models
}
\references{
Chow, S.-M., Hamaker, E. L., & Allaire, J. C. (2009).
Using innovative outliers to detect discrete shifts in dynamics in group-based state-space models. _Multivariate Behavioral Research_, 44, 465-496.
}

