% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper3D.R
\name{get.section.densities.3d}
\alias{get.section.densities.3d}
\title{Extract tldCube and autodifferences functions from track sections}
\usage{
get.section.densities.3d(trackSections, gradientDensity = TRUE,
  heightDistEllipsoid = TRUE, DEM = NULL, maxBin = 25)
}
\arguments{
\item{trackSections}{list of track sections got by the \link[eRTG3D]{track.split.3d} function}

\item{gradientDensity}{logical: Should a distribution of the gradient angle be extracted and later used in the simulations?}

\item{heightDistEllipsoid}{logical: Should a distribution of the flight height over ellipsoid be extracted and later used in the sim.cond.3d()?}

\item{DEM}{a raster containing a digital elevation model, covering the same extent as the track sections}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube (\link[eRTG3D]{turnLiftStepHist})}
}
\value{
A list containing the tldCube and the autodifferences functions (and additionally the height distribution function)
}
\description{
Creates a list consisting of the 3 dimensional
probability distribution cube for turning angle, lift angle and step length (\link[eRTG3D]{turnLiftStepHist})
as well as the uni-dimensional distributions of the differences
of the turning angles, lift angles and step lengths with a lag of 1 to maintain
minimal level of autocorrelation in each of the terms.
}
\examples{
get.section.densities.3d(list(niclas[1:10, ], niclas[11:nrow(niclas), ]))
}
