% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{et_analyze}
\alias{et_analyze}
\title{et_analyze}
\usage{
et_analyze(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x0,
  y0, x1, y1, x2, y2, j2000, o1, resonance, max_amp, update_coef)
}
\arguments{
\item{astro}{vector astronomical parameters}

\item{astro_der}{vector derivative of astronomical parameters}

\item{k_mat}{matrix tidal catalog values}

\item{pk}{vector of phases for each group}

\item{body}{vector of body tide for each group}

\item{body_inds}{indices of body max for each group}

\item{delta}{vector body}

\item{deltar}{double gravimentric factor}

\item{x0}{vector tidal catalog values}

\item{y0}{vector tidal catalog values}

\item{x1}{vector tidal catalog values}

\item{y1}{vector tidal catalog values}

\item{x2}{vector tidal catalog values}

\item{y2}{vector tidal catalog values}

\item{j2000}{double Julian date}

\item{o1}{double frequency}

\item{resonance}{double frequency}

\item{max_amp}{int index of the wave with maximum amplitude in wave group}

\item{update_coef}{double constant for phase updating}
}
\value{
synthetic gravity
}
\description{
Calculate tidal potential for a single time and multiple waves.  Code adapted from ETERNA.
}
\references{
Wenzel, H.-G. (1996): The nanogal software: Earth tide data
processing package ETERNA 3.3. Bulletin d'Informations
Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
}
\author{
Jonathan Kennel, \email{jkennel@uoguelph.ca}
}
