% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FairSprErr.R
\name{FairSprErr}
\alias{FairSprErr}
\title{Fair spread-error ratio}
\usage{
FairSprErr(ens, obs)
}
\arguments{
\item{ens}{n x k matrix of n forecasts for k ensemble members}

\item{obs}{vector with n verifying observations}
}
\description{
Modular function that computes the spread to error ratio (\code{SPR}) for
probabilistic forecasts - not unlike the functions in SpecsVerification.
\code{SPR > 1} indicates overdispersion (underconfidence), whereas \code{SPR
< 1} indicates overconfidence in the forecasts.
}
\details{
Here we define the spread-error rate as the square root of the ratio
  of mean ensemble variance to the mean squared error of the ensemble mean
  with the verifying observations. We inflate the intra ensemble sample
  variance to account for the finite ensemble size as in Weigel (2011).
}
\examples{
tm <- toymodel()
FairSprErr(tm$fcst, tm$obs)

## compute spread to error ratio using veriApply
veriApply('FairSprErr', fcst=tm$fcst, obs=tm$obs)

## compare with 'unfair' spread to error ratio
veriApply("EnsSprErr", fcst=tm$fcst, obs=tm$obs)
}
\references{
Weigel, A.P. (2012). Ensemble forecasts. Forecast Verification: A
  Practitioner's Guide in Atmospheric Science, Second Edition, 141-166.
}
\seealso{
\code{\link{veriApply}}, \code{\link{FairSprErr}}
}

