% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xldate.R
\name{xldate}
\alias{xldate}
\title{Convert Excel Number to Date}
\usage{
xldate(
  x,
  origin = "1899-12-30",
  nastrings = easyr::nastrings,
  preprocessed.values = NULL,
  ifna = c("return-unchanged", "error", "warning", "return-na"),
  verbose = TRUE,
  allow_times = FALSE,
  do.month.char = TRUE,
  min.acceptable = lubridate::ymd("1920-01-01"),
  max.acceptable = lubridate::ymd("2050-01-01")
)
}
\arguments{
\item{x}{Vector of values.}

\item{origin}{Zero value to use in date conversion. Older version of excel might use a different value.}

\item{nastrings}{Vector of characters to be considered NAs. todate will treat these like NAs. Defaults to the easyr::nastrings list.}

\item{preprocessed.values}{Strings need to have NAs set, lowercase and be trimmed before they can be checked. To avoid doing this twice, you can tell the function that it has already been done.}

\item{ifna}{Action to take if NAs are created. 'return-unchanged'  returns the sent vector unchanged; 'warning' results in a warning and returns the converted vector with new NAs; 'error' results in an error.}

\item{verbose}{Choose to view messaging.}

\item{allow_times}{Return values with time, not just the date.}

\item{do.month.char}{Convert month character names like Feb, March, etc.}

\item{min.acceptable}{Set NA if converted value is less than this value. Helps to prevent numbers from being assumed as dates. Set NULL to skip this check.}

\item{max.acceptable}{Set NA if converted value is greater than this value. Helps to prevent numbers from being assumed as dates. Set NULL to skip this check.}
}
\value{
Vector of converted values.
}
\description{
Converts dates formatted as long integers from Excel to Date format in R, accounting for known Excel leap year errors.
Author: Bryce Chamberlain. Tech review: Dominic Dillingham.
}
\examples{
xldate( c('7597', '42769', '47545', NA ) )
}
