% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_spss2.R
\name{write_spss2}
\alias{write_spss2}
\title{Write a \code{GADSdat} object to \code{txt} and \code{SPSS} syntax}
\usage{
write_spss2(
  GADSdat,
  txtPath,
  spsPath = NULL,
  savPath = NULL,
  dec = ".",
  fileEncoding = "UTF-8",
  chkFormat = TRUE,
  ...
)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{txtPath}{Path of \code{.txt} file to write, including file name and ending \code{.txt}. No default.}

\item{spsPath}{Path of \code{.sps} file to write, including file name and ending \code{.sps}. Default Path is \code{txtPath}.}

\item{savPath}{Path of \code{.sav} file to write, including file name and ending \code{.sav}. Default Path is \code{spsPath}.}

\item{dec}{Decimal delimiter for your SPSS version. Other values for \code{dec} than \code{","} or \code{"."} are not implemented yet.}

\item{fileEncoding}{Data file encoding for SPSS. Default is \code{"UTF-8"}.}

\item{chkFormat}{Whether format checks via \code{checkFormat} should be performed.}

\item{...}{Arguments to pass to \code{checkFormat} in particular \code{changeFormat=FALSE} if needed.}
}
\value{
Writes a \code{txt} and an \code{sav} file to disc, returns nothing.
}
\description{
Write a \code{GADSdat} object to a text file (\code{txt}) and an accompanying \code{SPSS} syntax file containing all meta information (e.g. value and variable labels).
}
\details{
This function is based on \code{eatPreps} \code{writeSpss} function and is currently under development.
}
\examples{

# write to spss
tmp_txt <- tempfile(fileext = ".txt")
write_spss2(pisa, txtPath = tmp_txt)

}
