% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-constructor.R
\name{ecop.from_symbol_conf}
\alias{ecop.build_opt}
\alias{ecop.from_symbol_conf}
\alias{ecop.read_symbol_conf}
\title{Constructor of ecop class by read conf for option sample data}
\usage{
ecop.from_symbol_conf(key, conf_file = "conf/ecop-fit-conf.yml",
  conf_data = NULL)

ecop.read_symbol_conf(key, conf_file = "conf/ecop-fit-conf.yml")

ecop.build_opt(ecop, df, otype)
}
\arguments{
\item{key}{character. The top-level key in conf}

\item{conf_file}{file name fof symbol config, default to conf/ecld-fit-conf.yml}

\item{conf_data}{optionally feed config through a list.
If this is not null, this takes priority and \code{conf_file} will be ignored.}

\item{ecop}{an ecop object with conf}

\item{df}{dataframe of a single closing date and time to maturity}

\item{otype}{option type}
}
\value{
the ecop object
}
\description{
Read conf for option sample data and fitting parameters
}
\examples{
\dontrun{
    conf <- ecop.read_symbol_conf("spx2_1d")
    op <- ecop.from_symbol_conf("spx2_1d")
}
}
\author{
Stephen H-T. Lihn
}
\keyword{constructor}

