% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-cusp-std-moment-method.R
\name{ecd.cusp_std_moment}
\alias{ecd.cusp_std_moment}
\alias{ecd.cusp_std_cf}
\alias{ecd.cusp_std_mgf}
\title{The moments, characteristic function (CF), and moment generating function (MGF)
of standard cusp distribution.}
\usage{
ecd.cusp_std_moment(n)

ecd.cusp_std_cf(t, mu = 0, sigma = 1, rel.tol = 1e-08,
  show.warning = FALSE)

ecd.cusp_std_mgf(t, mu = 0, sigma = 1, rel.tol = 1e-07,
  show.warning = FALSE)
}
\arguments{
\item{n}{integer vector specifying the n-th moments}

\item{t}{numeric vector for CF and MGF}

\item{mu}{length-one numeric, specifying mean for CF and MGF}

\item{sigma}{length-one numeric, specifying volatility for CF and MGF}

\item{rel.tol}{relative tolerance}

\item{show.warning}{logical, to show warning or not.}
}
\value{
the values of the moments, CF, MGF
}
\description{
The moments of standard cusp distribution are calculated via Gamma function.
The CF and MGF are calculated as sum of moment terms. The CF is a complex number.
Since the terms in MGF is ultimately diverging, the sum is truncated before
the terms are increasing.
}
\examples{
ecd.cusp_std_moment(c(2,4))

}
\keyword{cusp}
\keyword{ecd}
