% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-ellipticity-generic.R
\docType{methods}
\name{ellipticity.ecd}
\alias{ellipticity.ecd}
\alias{ellipticity}
\alias{ellipticity,ecd-method}
\title{Ellipticity of ecd object}
\usage{
\method{ellipticity}{ecd}(object, tol = 1e-04)

ellipticity(object, tol = 1e-05)

\S4method{ellipticity}{ecd}(object, tol = 1e-04)
}
\arguments{
\item{object}{An object of ecd class}

\item{tol}{Numeric, the tolerance of precision during subdivision.
Default: \code{1e-4} of stdev.}
}
\value{
a list with 3 major numbers: xe1= negative x_e, xe2= positive x_e, avg= ellipticity
}
\description{
Ellipticity of ecd object, defined as half of the distance
between the two elliptic points.
}
\examples{
d <- ecd(0,1)
ellipticity(d)
}
\keyword{ellipticity}
