% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimation.R
\name{get_estimation_gpg}
\alias{get_estimation_gpg}
\title{This function allows you to estimate the Gender Pay Wage Gap (GPG)}
\usage{
get_estimation_gpg(
  data = ech::toy_ech_2018,
  variable = "total_income_per_hour",
  e26 = "e26",
  by = NULL,
  ids = NULL,
  estrato = NULL,
  pesoano = "pesoano",
  stat = "media"
)
}
\arguments{
\item{data}{data.frame}

\item{variable}{Variable name of total income per hour}

\item{e26}{Variable name of sex}

\item{by}{data frame column}

\item{ids}{Variable name of cluster}

\item{estrato}{Variable name of strata}

\item{pesoano}{Variable name of weights}

\item{stat}{Media or Median}
}
\value{
table
}
\description{
This function allows you to estimate the Gender Pay Wage Gap (GPG)
}
\examples{
\donttest{
toy_ech_2018 <- labor_income_per_hour(data = ech::toy_ech_2018, base_month = 6, base_year = 2018)
get_estimation_gpg(data = toy_ech_2018, variable = "total_income_per_hour", e26 = "e26")
}
}
\seealso{
Other estimation: 
\code{\link{get_estimation_gini}()},
\code{\link{get_estimation_mean}()},
\code{\link{get_estimation_median}()},
\code{\link{get_estimation_qsr}()},
\code{\link{get_estimation_ratio}()},
\code{\link{get_estimation_total}()},
\code{\link{set_design}()}
}
\concept{estimation}
