% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_heatmap}
\alias{e_heatmap}
\alias{e_heatmap_}
\title{Heatmap}
\usage{
e_heatmap(e, y, z, name = NULL, coord.system = "cartesian2d",
  rm.x = TRUE, rm.y = TRUE, ...)

e_heatmap_(e, y, z = NULL, name = NULL, coord.system = "cartesian2d",
  rm.x = TRUE, rm.y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{y, z}{Coordinates and values.}

\item{name}{name of the serie.}

\item{coord.system}{Coordinate system to plot against, takes 
\code{cartesian2d}, \code{geo} or \code{calendar}.}

\item{rm.x, rm.y}{Whether to remove x and y axis, only applies if \code{coord.system} is not 
set to \code{cartesian2d}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw heatmap by coordinates.
}
\examples{
v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE), 
  y = sample(v, 300, replace = TRUE), 
  z = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) \%>\% 
  dplyr::group_by(x, y) \%>\% 
  dplyr::summarise(z = sum(z)) \%>\% 
  dplyr::ungroup()

matrix \%>\% 
  e_charts(x) \%>\% 
  e_heatmap(y, z) \%>\% 
  e_visual_map(z)

# calendar   
dates <- seq.Date(as.Date("2018-01-01"), as.Date("2018-12-31"), by = "day")
values <- rnorm(length(dates), 20, 6)

year <- data.frame(date = dates, values = values)

year \%>\% 
  e_charts(date) \%>\% 
  e_calendar(range = "2018") \%>\% 
  e_heatmap(values, coord.system = "calendar") \%>\% 
  e_visual_map(max = 30)

}
\seealso{
\href{Additional arguments}{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-heatmap}
}
