% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_histogram}
\alias{e_histogram}
\alias{e_density}
\alias{e_histogram_}
\alias{e_density_}
\title{Histogram & Density}
\usage{
e_histogram(e, serie, breaks = "Sturges", name = NULL, legend = TRUE,
  bar.width = "99\%", x.index = 0, y.index = 0, ...)

e_density(e, serie, breaks = "Sturges", name = NULL, legend = TRUE,
  x.index = 0, y.index = 0, ...)

e_histogram_(e, serie, breaks = "Sturges", name = NULL,
  legend = TRUE, bar.width = "99\%", x.index = 0, y.index = 0, ...)

e_density_(e, serie, breaks = "Sturges", name = NULL, legend = TRUE,
  x.index = 0, y.index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Column name of serie to plot.}

\item{breaks}{Passed to \code{\link{hist}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{bar.width}{Width of bars.}

\item{x.index}{Indexes of x and y axis.}

\item{y.index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add a histogram or density plots.
}
\examples{
mtcars \%>\% 
  e_charts() \%>\% 
  e_histogram(mpg, name = "histogram") \%>\% 
  e_density(mpg, areaStyle = list(opacity = .4), smooth = TRUE, name = "density", y.index = 1) \%>\% 
  e_tooltip(trigger = "axis")

}
