% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.paxis}
\alias{ec.paxis}
\title{Parallel Axis}
\usage{
ec.paxis(dfwt = NULL, cols = NULL, minmax = TRUE, ...)
}
\arguments{
\item{dfwt}{An echarty widget OR a data.frame(regular or grouped)}

\item{cols}{A string vector with columns names in desired order}

\item{minmax}{Boolean to add max/min limits or not, default TRUE}

\item{...}{Additional attributes for \href{https://echarts.apache.org/en/option.html#parallelAxis}{parallelAxis}.}
}
\value{
A list, see format in \href{https://echarts.apache.org/en/option.html#parallelAxis}{parallelAxis}.
}
\description{
Build 'parallelAxis' for a parallel chart
}
\details{
This function could be chained to \emph{ec.init} or used with a \emph{data.frame}\cr
}
\examples{
iris |> dplyr::group_by(Species) |>    # chained
ec.init(ctype= 'parallel', series.param= list(lineStyle= list(width=3))) |> 
ec.paxis(cols= c('Petal.Length','Petal.Width','Sepal.Width'))

mtcars |> ec.init(ctype= 'parallel', 
   parallelAxis= ec.paxis(mtcars, cols= c('gear','cyl','hp','carb'), nameRotate= 45),
   series.param= list(smooth= TRUE)
)

}
