% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_cbo.R
\name{sim_cbo}
\alias{sim_cbo}
\alias{simcbo}
\title{Simulated cost-benefit optimization}
\usage{
sim_cbo(comp.var, multSE = NULL, ct = NULL, ck, cj = NULL)
}
\arguments{
\item{comp.var}{Data frame as obtained from \code{\link[=scompvar]{scompvar()}}.}

\item{multSE}{Optional. Required multivariate standard error for the
sampling experiment.}

\item{ct}{Optional. Total cost for the sampling experiment.}

\item{ck}{Cost per replicate.}

\item{cj}{Cost per unit.}
}
\value{
A data frame containing the optimized values for \code{m} number of
sites and \code{n} number of samples to consider.
}
\description{
\code{sim_cbo()} can be used to apply a cost-benefit optimization model that
depends either on a desired level of precision or on a budgeted total cost,
as proposed by Underwood (1997).
}
\examples{
compVar <- scompvar(data = simResults)

sim_cbo(comp.var = compVar, multSE = NULL, ct = 20000, ck = 100, cj = 2500)
sim_cbo(comp.var = compVar, multSE = 0.15, ct = NULL, ck = 100, cj = 2500)
}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.

Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=scompvar]{scompvar()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
