% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_search.R
\name{ee_search_obs}
\alias{ee_search_obs}
\title{Search observations}
\usage{
ee_search_obs(query = NULL, page = NULL, page_size = 1000,
  quiet = FALSE, progress = TRUE, foptions = list())
}
\arguments{
\item{query}{= The search term}

\item{page}{Page number}

\item{page_size}{The number of observations per page returned by the query. The package default is \code{250} observations. The API default, however, is \code{10}. Setting this number higher will require fewer calls (i.e. pages) but a large size may also fail or timeout.}

\item{quiet}{Default is \code{FALSE}. Set to \code{TRUE} to suppress messages.}

\item{progress}{Progress bar is set to \code{TRUE} by default. Use \code{FALSE} especially when calling functions inside documents.}

\item{foptions}{A list of additional arguments for \code{httr}. There is no reason to use this argument except for debugging purposes.}
}
\value{
data.frame
}
\description{
A powerful way to search through the observations.
}
\examples{
# general_lynx_query <- ee_search_obs(query  = "Lynx")
 \dontrun{
# lynx_data <- ee_search_obs(query  = "genus:Lynx")
# all_lynx_data <- ee_search_obs(query  = "Lynx", page = "all")
}
}
\seealso{
\code{\link{ee_search})}
}
\keyword{search}

