#' Additional data to assist with plotting outputs from \code{\link{WelshStreams}}
#'
#' The rank order of 16 prey taxa in \code{\link{WelshStreams}} on the Centre for
#'   Ecology and Hydrology's Coded Macroinvertebrate List
#'   \url{https://www.ceh.ac.uk/services/coded-macroinvertebrates-list}. This is
#'   used primarily for controlling the order in which prey taxa are plotted
#'   with \code{\link{plot_preferences}}.
#'
#' @format A data frame with 16 rows and two columns:
#' \describe{
#'   \item{Taxon}{The names of each prey taxon}
#'   \item{CEH}{The rank order of the taxa based on the Centre for Ecology and
#'     Hydrology's Coded Macroinvertebrate List}
#'  }
#'
#' @source Pearson, C.E. (2015) \emph{Effects of agricultural intensification
#'   on the ecology of upland stream invertebrate communities}. Unpublished
#'   PhD thesis, Cardiff University.
#'

"WelshStreams.order"
