% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostatscale.R
\name{symdyn}
\alias{symdyn}
\title{Simulate time series for a single species in a single patch}
\usage{
symdyn(
  r,
  f,
  d,
  d_sd,
  sf,
  tmax,
  stochd = TRUE,
  stocht = TRUE,
  as.matrix = FALSE,
  oscillate_dist = FALSE
)
}
\arguments{
\item{r}{per-capita growth rate (r in Eq.1)}

\item{f}{the waiting time (or average waiting time) between disturbance events (equal to 1/lambda in Eq.1)}

\item{d}{mean size of disturbance function (mu in Eq.1)}

\item{d_sd}{standard deviation of disturbance function (sigma in Eq.1)}

\item{sf}{waiting time between sampling events}

\item{tmax}{the time series length to be simulated}

\item{stochd}{a logical variable, indicating whether disturbance size should be stochastic - otherwise, all disturbances are of magnitude d - defaults to TRUE}

\item{stocht}{a logical variable, indicating whether waiting time between disturbance events should be stochastic - otherwise, waiting time is always f - defaults to TRUE}

\item{as.matrix}{indicates whether results should be returned as matrix (potentially faster for some applications) - defaults to FALSE}

\item{oscillate_dist}{a logical variable indicating whether the sign of the disturbance should oscillate between positive and negative - ignored if stochd==TRUE - defaults to FALSE}
}
\value{
a matrix or data.frame with columns for sampling times, abundances, and number of disturbances for each time interval
}
\description{
Function for simulating dynamics from Eq.1 in the main text.
}
\examples{
# see xt2fun
}
