% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lampreytime.R
\docType{data}
\name{lampreytime}
\alias{lampreytime}
\title{Lethal time data for seasonal exposure to TFM for larval sea lamprey}
\format{A data frame containing 64 rows and 7 columns.
\describe{
\item{nominal.dose}{nominal TFM dose(mg/L)}
\item{dose}{averaged measured TFM dose (mg/L) over 12 h of exposures}
\item{month}{month in which toxicity test occurred}
\item{hour}{duration of exposure in hours}
\item{response}{number of lamprey that responded over 12 h exposure to TFM}
\item{survive}{number of lamprey that survived over 12 h exposure to TFM}
\item{total}{total number of lamprey that were exposed to TFM over 12 h}
}}
\source{
Hlina, B.L., Birceanu, O., Tessier, L.R., Robinson, C.,  Muhametsafina, A., Bragg, L.M, Servos, M.R., Wilkie, M.P. In Preparation. Changes in the sensitivity of piscicide in an invasive species. Environmental Science & Technology.
}
\usage{
lampreytime
}
\description{
This dataset contains the amount of responding/dead lamprey from 1 to 12 h of exposure to the piscicide, 3-trifluoromethyl-4-nitrophenol (TFM), for the calculated LC50s at each month for the 2011 seasonal larval sea lamprey TFM toxicity data.
}
\details{
For each month, new lamprey were collected from the deer creek, MI, and were randomly assigned to a tank for exposure to the piscicide, 3-trifluoromethyl-4-nitrophenol (TFM). The LC50 at each month was then calculated and the amount of responding/dead lamprey from 1 to 12 h was recorded.
}
\keyword{datasets}
