% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupEvolutionaryOperators.R
\name{setupEvolutionaryOperators}
\alias{setupEvolutionaryOperators}
\title{Enhance control object with evolutionary operators.}
\usage{
setupEvolutionaryOperators(control,
  parent.selector = getDefaultEvolutionaryOperators(control$representation,
  "parent.selector"),
  survival.selector = getDefaultEvolutionaryOperators(control$representation,
  "survival.selector"),
  generator = getDefaultEvolutionaryOperators(control$representation,
  "generator"),
  mutator = getDefaultEvolutionaryOperators(control$representation,
  "mutator"),
  recombinator = getDefaultEvolutionaryOperators(control$representation,
  "recombinator"))
}
\arguments{
\item{control}{[\code{ecr_control}]\cr
ECR control object generated via \code{\link{setupECRControl}}.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{survival.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedurce to extract individuals from
a given set, which should survive and set up the next generation.}

\item{generator}{[\code{ecr_generator}]\cr
Generator operator of type \code{ecr_generator} for the generation of the initial
population.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}
}
\value{
[\code{ecr_control}] Modified control object.
}
\description{
Define the toolbox of all the evolutionary operators you wish to operate on
your problem.
}
\note{
Keep in mind, that all of the provided operators need to be compatible
with the \dQuote{representation} stored in the \code{control} object.
}

